//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.IO;
using System.IO.IsolatedStorage;
using System.Diagnostics;

namespace CLRUnleashed
{
	/// <summary>
	/// Podsumowanie dla IsolatedStorageTest.
	/// </summary>
	class IsolatedStorageTest
	{
		/// <summary>
		/// Gwny punkt wejcia dla aplikacji.
		/// </summary>
		[STAThread]
		static void Main(string[] args)
		{
			IsolatedStorageFile isf = IsolatedStorageFile.GetUserStoreForAssembly();
			Console.WriteLine(string.Format("Tosamo podzespou: {0}", isf.AssemblyIdentity));
			Console.WriteLine(string.Format("Aktualna wielko: {0}", isf.CurrentSize));
			Console.WriteLine(string.Format("Maksymalna wielko: {0}", isf.MaximumSize));
			Console.WriteLine(string.Format("Zakres: {0}", isf.Scope));

			// Poniszy fragment kodu sprawdza, czy plik ju istnieje.
			string[] fileNames = isf.GetFileNames("TestStore.txt");
			foreach (string file in fileNames)
			{
				if(file == "TestStore.txt")
				{

					Console.WriteLine("Plik ju istnieje");
					Console.WriteLine("Wpisz \"StoreAdm /REMOVE\" w wierszu polece, aby usun wszystkie izolowane magazyny dla tego uytkownika.");

					// Wyjcie z programu.
					isf.Close();
					return;
				}
			}

			writeToFile(isf);

			Console.WriteLine("Plik \"TestStore.txt\" zawiera:");

			// Wywoanie readFromFile i zapisanie otrzymanego cigu
			// do konsoli.

			Console.WriteLine(readFromFile(isf));

			// Wyjcie z programu.
			isf.Close();
		}

		// Ta metoda zapisuje "Witaj izolowany magazynie" do pliku.
		private static void writeToFile(IsolatedStorageFile isoStore)
		{

			// Deklaracja nowego StreamWritera.

			StreamWriter writer = null;

			// Przydzielenie StreamWritera do magazynu i pliku TestStore.

			writer = new StreamWriter(new IsolatedStorageFileStream("TestStore.txt", FileMode.CreateNew,isoStore));

			// Zapisanie "Witaj izolowany magazynie" w magazynie.

			writer.WriteLine("Witaj izolowany magazynie");

			writer.Close();
      
			Console.WriteLine("Dokonano zapisu do pliku.");

		}
		// Ta metoda odczytuje pierwszy wiersz pliku "TestStore.txt".

		public static String readFromFile(IsolatedStorageFile isoStore)
		{

			// Poniszy kod otwiera plik TestStore.txt i odczytuje cig.

			StreamReader reader = new StreamReader(new IsolatedStorageFileStream("TestStore.txt", FileMode.Open,isoStore));

			// Odczyt wiersza z pliku i dodanie go do sb.

			String sb = reader.ReadLine();

			// Zamknicie StreamReadera.

			reader.Close();

			// Zwrcenie cigu.

			return sb.ToString();

		}// Koniec readFromFile.

	}
}
